import React from 'react';
import { CurrencyCode } from '@shopify/react-i18n';
import { RequirementType } from '~/constants';
import type { PositiveNumericString } from '~/types';
export interface MinimumRequirementsProps {
    /**
     * The type of minimum requirement (e.g. none, subtotal, quantity)
     */
    requirementType: RequirementType;
    /**
     * (optional) The minimum quantity requirement for the discount
     */
    quantity?: PositiveNumericString;
    /**
     * (optional) The minimum subtotal requirement for the discount. NOTE: requires currencyCode to be passed
     */
    subtotal?: PositiveNumericString;
    /**
     * (optional) The currencyCode that should be used to format the subtotal amount
     */
    currencyCode?: CurrencyCode;
}
export declare function MinimumRequirements({ requirementType, quantity, subtotal, currencyCode, }: MinimumRequirementsProps): React.JSX.Element | null;
