import React from 'react';
import { CurrencyCode } from '@shopify/react-i18n';
import type { PositiveNumericString } from '~/types';
export interface MaximumShippingPriceProps {
    /**
     * Maximum shipping price, displayed when the user selects to exclude shipping rates
     */
    maximumShippingPrice: PositiveNumericString;
    /**
     * The currency code that should be used to format the input value
     */
    currencyCode: CurrencyCode;
}
export declare function MaximumShippingPrice({ maximumShippingPrice, currencyCode, }: MaximumShippingPriceProps): React.JSX.Element | null;
