import React from 'react';
import { CurrencyCode } from '@shopify/react-i18n';
import type { Field, PositiveNumericString } from '~/types';
import { AppliesTo, DiscountMethod, RequirementType } from '~/constants';
export interface MinimumRequirementsCardProps {
    /**
     * Field that controls the selected requirement type (e.g. none, minimum amount, minimum quantity)
     */
    requirementType: Field<RequirementType>;
    /**
     * Field for the subtotal minimum requirement
     */
    subtotal: Field<PositiveNumericString | undefined>;
    /**
     * Field for the quantity minimum requirement
     */
    quantity: Field<PositiveNumericString | undefined>;
    /**
     * The discount method (e.g. code, automatic) of the current discount
     */
    discountMethod: DiscountMethod;
    /**
     * Used to render a string describing what entity the minimum requirements apply to (collections, selected products, all products)
     */
    appliesTo: AppliesTo;
    /**
     * The currency code that should be used to format the input value
     */
    currencyCode: CurrencyCode;
    /**
     * (optional) If this discount supports selling plans, adds selling plan specific language
     */
    isRecurring?: boolean;
}
export declare function MinimumRequirementsCard({ appliesTo, currencyCode, requirementType, subtotal, quantity, discountMethod, isRecurring, }: MinimumRequirementsCardProps): React.JSX.Element;
