import React from 'react';
import { CurrencyCode } from '@shopify/react-i18n';
import { FormattedNumberFieldProps } from '../FormattedNumberField';
export declare type CurrencyFieldProps = FormattedNumberFieldProps & {
    /**
     * The currency code of the shop (e.g. `USD`).
     */
    currencyCode: CurrencyCode;
    /**
     * (optional) When true, appends the `suffix` prop from FormattedNumberFieldProps to the currency for currencies that display the currency symbol as a suffix (e.g. 200€)
     */
    appendSuffixToCurrency?: boolean;
    /**
     * (optional) When true, hides the currency symbol.
     */
    hideCurrencyCode?: boolean;
    /**
     * (optional) When true, hides the prefix.
     */
    hidePrefix?: boolean;
    /**
     * (optional) When true, hides the suffix.
     */
    hideSuffix?: boolean;
};
declare function CurrencyField({ currencyCode, hideCurrencyCode, hidePrefix, hideSuffix, appendSuffixToCurrency, suffix, prefix, ...rest }: CurrencyFieldProps): React.JSX.Element;
declare const _default: React.MemoExoticComponent<typeof CurrencyField>;
export default _default;
