import React from 'react';
import { CurrencyCode } from '@shopify/react-i18n';
import type { Field, PositiveNumericString, CountryCode } from '~/types';
import { CountrySelectionType } from '~/constants';
export interface CountriesAndRatesCardProps {
    /**
     * Whether a discount applies to all countries or specific countries
     */
    countrySelectionType: Field<CountrySelectionType>;
    /**
     * Specific country codes that a discount applies to
     */
    selectedCountries: Field<CountryCode[]>;
    /**
     * If the discount only applies when shipping rates are under a certain amount
     */
    excludeShippingRates: Field<boolean>;
    /**
     * The maximum shipping rate where the discount applies
     */
    maximumShippingPrice: Field<PositiveNumericString>;
    /**
     * Widget that enables users to select countries (see docs for an example)
     */
    countrySelector: React.ReactNode;
    /**
     * The currency code used for the maxiumum shipping price input
     */
    currencyCode: CurrencyCode;
}
export declare function CountriesAndRatesCard({ countrySelectionType, selectedCountries, maximumShippingPrice, excludeShippingRates, countrySelector, currencyCode, }: CountriesAndRatesCardProps): React.JSX.Element;
