import React from 'react';
import './AppProvider.scss';
export interface AppProviderProps {
    /**
     * Locale of the shop (e.g. `en-US`).
     */
    locale: string;
    /**
     * The shop's time zone as defined by the IANA (e.g. `America/Los_Angeles`). This can be queried from the [Shop gql object](https://shopify.dev/api/admin-graphql/2022-07/objects/Shop#field-shop-ianatimezone).
     */
    ianaTimezone: string;
    children?: React.ReactNode;
}
export declare function AppProvider(props: AppProviderProps): React.JSX.Element;
