import React from 'react';
import { Field, PositiveNumericString } from '~/types';
import { RecurringPaymentType } from '~/constants';
export declare enum UsageLimitType {
    TotalUsageLimit = "TOTAL_USAGE_LIMIT",
    OncePerCustomerLimit = "ONCE_PER_CUSTOMER_LIMIT"
}
interface UsageLimitProps {
    /**
     * The total number of times the discount can be used.
     */
    totalUsageLimit: Field<PositiveNumericString | null>;
    /**
     * When selected, the discount may be used at most once per customer
     */
    oncePerCustomer: Field<boolean>;
    /**
     * (optional) When true, displays the "Recurring payments" section. (see {@interface UsageLimitsCardMultiplePaymentsProps})
     */
    isRecurring?: false;
}
interface UsageLimitsCardMultiplePaymentsProps extends Pick<UsageLimitProps, Exclude<keyof UsageLimitProps, 'isRecurring'>> {
    /**
     * Displays the "Recurring payments" section.
     */
    isRecurring: true;
    /**
     * The recurring payment type (FIRST_PAYMENT, MULTIPLE_PAYMENTS, ALL_PAYMENTS)
     */
    recurringPaymentType: Field<RecurringPaymentType>;
    /**
     * The number of times the discount can be used for a recurring payment.
     */
    recurringPaymentLimit: Field<PositiveNumericString>;
}
export declare type UsageLimitsCardProps = UsageLimitProps | UsageLimitsCardMultiplePaymentsProps;
export declare const DISCOUNT_TOTAL_USAGE_LIMIT_FIELD = "totalUsageLimit";
export declare function UsageLimitsCard(props: UsageLimitsCardProps): React.JSX.Element;
export {};
