import React from 'react';
import { DateTime, Field } from '~/types';
export interface TimePickerProps {
    /**
     * Time field to be used for the time picker. The value should be in UTC.
     */
    time: Field<DateTime>;
    /**
     * Label to be displayed above the time picker input
     */
    label: string;
    /**
     * (optional) Controls visibility of the time picker input label
     *
     * @default false
     */
    labelHidden?: boolean;
    /**
     * (optional) Disables the time picker input
     *
     * @default false
     */
    disabled?: boolean;
    /**
     * (optional) If provided, sets a lower bound on the time if the date of {@param disableTimesBefore} is the same as the date of {@param time}. The value should be in UTC.
     */
    disableTimesBefore?: DateTime;
}
export declare function TimePicker({ label, labelHidden, time, disabled, disableTimesBefore, }: TimePickerProps): React.JSX.Element;
