import React from 'react';
import { Customer, CustomerSegment } from '~/types';
import { Eligibility } from '~/constants';
export interface CustomerEligibilityProps {
    /**
     * Who the discount applies to (all customers, specific customers, specific customer groups)
     */
    eligibility: Eligibility;
    /**
     * (optional) Specific customer segments the discount applies to
     */
    selectedCustomerSegments?: CustomerSegment[];
    /**
     * (optional) Specific customers the discount applies to
     */
    selectedCustomers?: Customer[];
}
export declare function CustomerEligibility({ eligibility, selectedCustomerSegments, selectedCustomers, }: CustomerEligibilityProps): React.JSX.Element | null;
