import React from 'react';
import { DateTime } from '~/types';
export interface ActiveDatesProps {
    /**
     * The start date of the discount. A DateTime value represented as an [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) timestamp in UTC.
     */
    startDate: DateTime;
    /**
     * The end date of the discount. A DateTime value represented as an [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) timestamp in UTC.
     */
    endDate: DateTime | null;
}
export declare function ActiveDates({ startDate, endDate }: ActiveDatesProps): React.JSX.Element;
