import React from 'react';
import { ActiveDatesProps, AppliesToPurchaseTypeProps, CombinationsProps, CustomerEligibilityProps, HeaderProps, MaximumShippingPriceProps, MinimumRequirementsProps, PerformanceProps, RecurringPaymentProps, SelectedCountriesProps, UsageLimitsProps } from './components';
export declare type SummaryCardProps = {
    /**
     * Discount summary props for the Header section. See {@link HeaderProps} for more details.
     */
    header: HeaderProps;
    /**
     * Props for the Performance section. See {@link PerformanceProps} for more details.
     */
    performance: PerformanceProps;
} & OptionalSectionsProps;
declare enum OptionalSection {
    activeDates = "activeDates",
    additionalDetails = "additionalDetails",
    appliesToPurchaseType = "appliesToPurchaseType",
    combinations = "combinations",
    customerEligibility = "customerEligibility",
    maximumShippingPrice = "maximumShippingPrice",
    minimumRequirements = "minimumRequirements",
    recurringPayment = "recurringPayment",
    selectedCountries = "selectedCountries",
    usageLimits = "usageLimits"
}
interface OptionalSectionsProps {
    /**
     * (optional) Renders a section that describes the discounts active dates. See {@link ActiveDatesProps} for more details.
     */
    [OptionalSection.activeDates]?: ActiveDatesProps;
    /**
     * (optional) Entries are displayed as bullet points under the details subheading.
     */
    [OptionalSection.additionalDetails]?: string[];
    /**
     * (optional) Renders a purchase type (e.g. one-time, subscription, both) section. See {@link AppliesToPurchaseTypeProps} for more details.
     */
    [OptionalSection.appliesToPurchaseType]?: AppliesToPurchaseTypeProps;
    /**
     * (optional) Renders a section that describes how a discount combines. See {@link CombinationsProps} for more details.
     */
    [OptionalSection.combinations]?: CombinationsProps;
    /**
     * (optional) Renders a section that describes which customers a discount applies to. See {@link CustomerEligibilityProps} for more details.
     */
    [OptionalSection.customerEligibility]?: CustomerEligibilityProps;
    /**
     * (optional) Renders a section that lists the maximum shipping price allowed for the discount to be abpplied. See {@link MaximumShippingPrice} for more details.
     */
    [OptionalSection.maximumShippingPrice]?: MaximumShippingPriceProps;
    /**
     * (optional) Renders a section for the minimum discount purchase requirements (e.g. minimum subtotal, minimum purchase quantity). See {@link MinimumRequirementsProps} for more details.
     */
    [OptionalSection.minimumRequirements]?: MinimumRequirementsProps;
    /**
     * (optional) Renders a section that describes how the discount applies on recurring payment orders (e.g. subscription). See {@link RecurringPaymentProps} for more details.
     */
    [OptionalSection.recurringPayment]?: RecurringPaymentProps;
    /**
     * (optional) Renders a section for the countries where the discount applies. See {@link SelectedCountriesProps} for more details.
     */
    [OptionalSection.selectedCountries]?: SelectedCountriesProps;
    /**
     * (optional) Renders a section that describes how many times the discount may be used. See {@link UsageLimitsProps} for more details.
     */
    [OptionalSection.usageLimits]?: UsageLimitsProps;
}
export declare function SummaryCard(props: SummaryCardProps): React.JSX.Element;
export {};
