import React from 'react';
import { Field } from '~/types';
export interface DiscountCodeGeneratorProps {
    /**
     * Field to be used for the discount code.
     */
    discountCode: Field<string>;
    /**
     * (optional) If provided, sets the default length of generated discount codes
     *
     * @default DEFAULT_DISCOUNT_CODE_LENGTH
     */
    defaultLength?: number;
}
export declare function DiscountCodeGenerator({ discountCode, defaultLength, }: DiscountCodeGeneratorProps): React.JSX.Element;
