import React from 'react';
import { DateTime, Field } from '~/types';
import { Weekday } from '~/constants';
export interface DatePickerProps {
    /**
     * Date field to be used for the Date picker.
     */
    date: Field<DateTime>;
    /**
     * Label to be displayed above the date picker input
     */
    label: string;
    /**
     * (optional) Controls visibility of the date picker input label
     *
     * @default false
     */
    labelHidden?: boolean;
    /**
     * (optional) Disables the date picker input
     *
     * @default false
     */
    disabled?: boolean;
    /**
     * (optional) Disable date selection before this date.  The value should be in UTC.
     */
    disableDatesBefore?: DateTime;
    /**
     * (optional) The day that should be used as the start of the week.
     *
     * @default Weekday.Sunday
     */
    weekStartsOn?: Weekday;
}
export declare function DatePicker({ date, label, labelHidden, disabled, disableDatesBefore, weekStartsOn, }: DatePickerProps): React.JSX.Element;
