import React from 'react';
import { DiscountClass } from '~/constants';
import { CombinableDiscountTypes, CombinableDiscountCounts, Field } from '~/types';
export interface CombinationCardProps {
    /**
     * The class of the current discount (shipping, product, order)
     */
    discountClass: DiscountClass;
    /**
     * The discount title for Automatic discounts, or discount code for Code discounts.
     */
    discountDescriptor: string;
    /**
     * Field used for setting which discount classes may be combined with this discount
     */
    combinableDiscountTypes: Field<CombinableDiscountTypes>;
    /**
     * (optional) The number of existing product, order, and shipping discount classes in the shop which can be combined with this discount
     */
    combinableDiscountCounts?: CombinableDiscountCounts;
    /**
     * (optional) The full GID of the current discount. Used to filter out the current discount from the combinations modal.
     */
    discountId?: string;
}
export declare function CombinationCard({ discountClass, discountDescriptor, combinableDiscountTypes, combinableDiscountCounts, discountId, }: CombinationCardProps): React.JSX.Element;
