import React from 'react';
import { Weekday } from '~/constants';
import { DateTime, Field } from '~/types';
export interface ActiveDatesCardProps {
    /**
     * Field to be used for the start date picker, with a DateTime value represented as an [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) timestamp in UTC
     */
    startDate: Field<DateTime>;
    /**
     * Field to be used for the end date picker, with a DateTime value represented as an [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) timestamp in UTC
     */
    endDate: Field<DateTime | null>;
    /**
     * The shop's time zone abbreviation. This can be queried from the [Shop gql object](https://shopify.dev/api/admin-graphql/2022-07/objects/Shop#field-shop-timezoneabbreviation).
     */
    timezoneAbbreviation: string;
    /**
     * (optional) The day that should be used as the start of the week.
     *
     * @default Weekday.Sunday
     */
    weekStartsOn?: Weekday;
    /**
     * (optional) Disables all inputs
     *
     * @default false
     */
    disabled?: boolean;
}
export declare function ActiveDatesCard({ startDate, endDate, timezoneAbbreviation, weekStartsOn, disabled, }: ActiveDatesCardProps): React.JSX.Element;
