import React, { useState, useEffect } from 'react';
import { LegacyCard, ChoiceList, LegacyStack, TextField, Text, InlineError } from '@shopify/polaris';
import { useI18n } from '@shopify/react-i18n';
import styles from './UsageLimitsCard.scss.js';
import { forcePositiveInteger } from '../../utilities/numbers.js';
import { RecurringPayment } from './components/RecurringPayment/RecurringPayment.js';

let UsageLimitType = /*#__PURE__*/function (UsageLimitType) {
  UsageLimitType["TotalUsageLimit"] = "TOTAL_USAGE_LIMIT";
  UsageLimitType["OncePerCustomerLimit"] = "ONCE_PER_CUSTOMER_LIMIT";
  return UsageLimitType;
}({});
const DISCOUNT_TOTAL_USAGE_LIMIT_FIELD = 'totalUsageLimit';
function UsageLimitsCard(props) {
  const {
    totalUsageLimit,
    oncePerCustomer,
    isRecurring
  } = props;
  const [showUsageLimit, setShowUsageLimit] = useState(totalUsageLimit.value !== null);
  const [i18n] = useI18n();
  useEffect(() => setShowUsageLimit(totalUsageLimit.value !== null), [totalUsageLimit.value]);
  const handleUsageLimitsChoicesChange = selectedUsageLimitTypes => {
    const newOncePerCustomer = selectedUsageLimitTypes.includes(UsageLimitType.OncePerCustomerLimit);

    // When the checkbox is toggled, either set the totalUsageLimit value to null (null === checkbox off) or an empty string (non-null === checkbox on)
    if (!selectedUsageLimitTypes.includes(UsageLimitType.TotalUsageLimit)) {
      totalUsageLimit.onChange(null);
    } else if (totalUsageLimit.value === null) {
      totalUsageLimit.onChange('');
    }
    newOncePerCustomer !== oncePerCustomer.value && oncePerCustomer.onChange(newOncePerCustomer);
  };
  return /*#__PURE__*/React.createElement(LegacyCard, {
    title: i18n.translate('DiscountAppComponents.UsageLimitsCard.title')
  }, /*#__PURE__*/React.createElement(LegacyCard.Section, null, /*#__PURE__*/React.createElement(ChoiceList, {
    title: i18n.translate('DiscountAppComponents.UsageLimitsCard.options'),
    titleHidden: true,
    allowMultiple: true,
    selected: [...(showUsageLimit ? [UsageLimitType.TotalUsageLimit] : []), ...(oncePerCustomer.value ? [UsageLimitType.OncePerCustomerLimit] : [])],
    choices: [{
      label: i18n.translate('DiscountAppComponents.UsageLimitsCard.totalUsageLimitLabel'),
      value: UsageLimitType.TotalUsageLimit,
      renderChildren: isSelected => /*#__PURE__*/React.createElement(LegacyStack, {
        vertical: true,
        spacing: "extraTight"
      }, isSelected && /*#__PURE__*/React.createElement("div", {
        className: styles.TotalUsageLimitTextField
      }, /*#__PURE__*/React.createElement(TextField, {
        id: DISCOUNT_TOTAL_USAGE_LIMIT_FIELD,
        label: i18n.translate('DiscountAppComponents.UsageLimitsCard.totalUsageLimitLabel'),
        autoComplete: "off",
        labelHidden: true,
        value: totalUsageLimit.value || '',
        onChange: nextValue => {
          totalUsageLimit.onChange(forcePositiveInteger(nextValue));
        },
        onBlur: totalUsageLimit.onBlur,
        error: Boolean(totalUsageLimit.error)
      })), isRecurring && /*#__PURE__*/React.createElement(Text, {
        as: "span",
        color: "subdued"
      }, i18n.translate('DiscountAppComponents.UsageLimitsCard.totalUsageLimitHelpTextSubscription')), isSelected && totalUsageLimit.error && /*#__PURE__*/React.createElement(InlineError, {
        fieldID: DISCOUNT_TOTAL_USAGE_LIMIT_FIELD,
        message: totalUsageLimit.error
      }))
    }, {
      label: i18n.translate('DiscountAppComponents.UsageLimitsCard.oncePerCustomerLimitLabel'),
      value: UsageLimitType.OncePerCustomerLimit
    }],
    onChange: handleUsageLimitsChoicesChange
  })), isShowRecurringPaymentSection(props) && /*#__PURE__*/React.createElement(LegacyCard.Section, null, /*#__PURE__*/React.createElement(RecurringPayment, {
    recurringPaymentType: props.recurringPaymentType,
    recurringPaymentLimit: props.recurringPaymentLimit
  })));
}
function isShowRecurringPaymentSection(props) {
  return Boolean(props.isRecurring);
}

export { DISCOUNT_TOTAL_USAGE_LIMIT_FIELD, UsageLimitType, UsageLimitsCard };
