import React from 'react';
import { List } from '@shopify/polaris';
import { useI18n } from '@shopify/react-i18n';
import { CountrySelectionType } from '../../../../constants.js';

const I18N_SCOPE = {
  scope: 'DiscountAppComponents.SummaryCard.SelectedCountries'
};
function SelectedCountries({
  countrySelectionType,
  selectedCountries
}) {
  const [i18n] = useI18n();
  if (countrySelectionType === CountrySelectionType.SelectedCountries && selectedCountries.length === 0) {
    return null;
  }
  if (countrySelectionType === CountrySelectionType.AllCountries) {
    return /*#__PURE__*/React.createElement(List.Item, null, i18n.translate('forAllCountries', I18N_SCOPE));
  }
  return selectedCountries.length === 1 ? /*#__PURE__*/React.createElement(List.Item, null, i18n.translate('forSpecificCountry', I18N_SCOPE, {
    countryName: i18n.translate(selectedCountries[0], {
      scope: 'DiscountAppComponents.Countries'
    })
  })) : /*#__PURE__*/React.createElement(List.Item, null, i18n.translate('forNumberOfCountries', I18N_SCOPE, {
    numberOfCountries: selectedCountries.length
  }));
}

export { SelectedCountries };
