import React from 'react';
import { List } from '@shopify/polaris';
import { useI18n } from '@shopify/react-i18n';
import { RecurringPaymentType } from '../../../../constants.js';

const I18N_SCOPE = {
  scope: 'DiscountAppComponents.SummaryCard.RecurringPayment'
};
function RecurringPayment({
  isRecurring,
  recurringPaymentType,
  recurringPaymentLimit
}) {
  const [i18n] = useI18n();
  if (!isRecurring) {
    return null;
  }
  switch (recurringPaymentType) {
    case RecurringPaymentType.MultiplePayments:
      return recurringPaymentLimit !== null && recurringPaymentLimit !== void 0 && recurringPaymentLimit.length ? /*#__PURE__*/React.createElement(List.Item, null, i18n.translate('subscriptionRecurringPayments', I18N_SCOPE, {
        count: Number(recurringPaymentLimit)
      })) : null;
    case RecurringPaymentType.AllPayments:
      return /*#__PURE__*/React.createElement(List.Item, null, i18n.translate('subscriptionRecurringPayments.none', I18N_SCOPE));
    case RecurringPaymentType.FirstPayment:
      return /*#__PURE__*/React.createElement(List.Item, null, i18n.translate('subscriptionRecurringPayments', I18N_SCOPE, {
        count: 1
      }));
    default:
      return null;
  }
}

export { RecurringPayment };
