import React from 'react';
import { useI18n } from '@shopify/react-i18n';
import { LegacyCard, VerticalStack, Text, List } from '@shopify/polaris';
import { Redirect } from '@shopify/app-bridge/actions';
import { DiscountStatus, DiscountMethod } from '../../../../constants.js';
import { AppBridgeLink } from '../../../AppBridgeLink/AppBridgeLink.js';

const CODE_DISCOUNT_ADMIN_REPORT_URL = `/reports/sales_by_discount`;
const I18N_SCOPE = {
  scope: 'DiscountAppComponents.SummaryCard.Performance'
};
function Performance({
  status,
  totalSales,
  hasReports,
  discountMethod,
  usageCount
}) {
  const [i18n] = useI18n();
  const isActiveOrExpired = status === DiscountStatus.Active || status === DiscountStatus.Expired;
  return /*#__PURE__*/React.createElement(LegacyCard.Section, {
    title: i18n.translate('title', I18N_SCOPE)
  }, /*#__PURE__*/React.createElement(VerticalStack, null, status === DiscountStatus.Scheduled && /*#__PURE__*/React.createElement(Text, {
    as: "span",
    color: "subdued"
  }, i18n.translate('notActive', I18N_SCOPE)), isActiveOrExpired && /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(List, {
    type: "bullet"
  }, /*#__PURE__*/React.createElement(List.Item, null, i18n.translate('usageCount', I18N_SCOPE, {
    usageCount
  })), totalSales && /*#__PURE__*/React.createElement(List.Item, null, i18n.translate('totalSales', I18N_SCOPE, {
    totalSales: i18n.formatCurrency(Number(totalSales.amount), {
      currency: totalSales.currencyCode
    })
  }))), hasReports && discountMethod === DiscountMethod.Code && /*#__PURE__*/React.createElement("p", null, /*#__PURE__*/React.createElement(AppBridgeLink, {
    action: Redirect.Action.ADMIN_PATH,
    url: CODE_DISCOUNT_ADMIN_REPORT_URL
  }, i18n.translate('performanceLink', I18N_SCOPE))))));
}

export { Performance };
