import React from 'react';
import { List } from '@shopify/polaris';
import { useI18n } from '@shopify/react-i18n';

function MaximumShippingPrice({
  maximumShippingPrice,
  currencyCode
}) {
  const [i18n] = useI18n();
  const priceAsNumber = Number(maximumShippingPrice);
  const validatedPrice = isNaN(priceAsNumber) ? '' : i18n.formatCurrency(priceAsNumber, {
    currency: currencyCode
  });
  if (priceAsNumber <= 0 || validatedPrice.length < 1) {
    return null;
  }
  return /*#__PURE__*/React.createElement(List.Item, null, i18n.translate('DiscountAppComponents.SummaryCard.RatesExclusion.forShippingRatesUnder', {
    value: validatedPrice
  }));
}

export { MaximumShippingPrice };
