import React from 'react';
import { useI18n } from '@shopify/react-i18n';
import { LegacyStack, Text, List, Badge } from '@shopify/polaris';
import { DiscountStatus } from '../../../../constants.js';

/**
 * When `isEditing` is true, the `discountStatus` must also be provided
 */

let BadgeStatus = /*#__PURE__*/function (BadgeStatus) {
  BadgeStatus["Success"] = "success";
  BadgeStatus["Attention"] = "attention";
  return BadgeStatus;
}({});
const I18N_SCOPE = {
  scope: 'DiscountAppComponents.SummaryCard.Header'
};
function Header(props) {
  const {
    discountMethod,
    discountDescriptor
  } = props;
  const [i18n] = useI18n();
  const trimmedDescriptor = discountDescriptor.trim();
  return /*#__PURE__*/React.createElement(LegacyStack, {
    vertical: true,
    spacing: "loose"
  }, trimmedDescriptor ? /*#__PURE__*/React.createElement(LegacyStack, {
    distribution: "equalSpacing",
    alignment: "center",
    wrap: true
  }, /*#__PURE__*/React.createElement(Text, {
    variant: "headingMd",
    as: "h3"
  }, trimmedDescriptor), isEditing(props) && renderBadgeForStatus(props.discountStatus, i18n)) : /*#__PURE__*/React.createElement(Text, {
    as: "span",
    fontWeight: "semibold",
    color: "subdued"
  }, i18n.translate(`emptyState.${discountMethod}`, I18N_SCOPE)), /*#__PURE__*/React.createElement(LegacyStack, {
    vertical: true,
    spacing: "tight"
  }, /*#__PURE__*/React.createElement(Text, {
    variant: "headingXs",
    as: "h3"
  }, i18n.translate('typeAndMethod', I18N_SCOPE)), /*#__PURE__*/React.createElement(List, {
    type: "bullet"
  }, /*#__PURE__*/React.createElement(List.Item, null, props.appDiscountType), /*#__PURE__*/React.createElement(List.Item, null, i18n.translate(`discountMethod.${discountMethod}`, I18N_SCOPE)))));
}
function renderBadgeForStatus(status, i18n) {
  switch (status) {
    case DiscountStatus.Active:
      return /*#__PURE__*/React.createElement(Badge, {
        status: BadgeStatus.Success
      }, i18n.translate('badge.active', I18N_SCOPE));
    case DiscountStatus.Expired:
      return /*#__PURE__*/React.createElement(Badge, null, i18n.translate('badge.expired', I18N_SCOPE));
    case DiscountStatus.Scheduled:
      return /*#__PURE__*/React.createElement(Badge, {
        status: BadgeStatus.Attention
      }, i18n.translate('badge.scheduled', I18N_SCOPE));
    default:
      return null;
  }
}
function isEditing(props) {
  return Boolean(props.isEditing);
}

export { BadgeStatus, Header };
