import React from 'react';
import { List } from '@shopify/polaris';
import { useI18n } from '@shopify/react-i18n';
import { DiscountClass } from '../../../../constants.js';

const I18N_SCOPE = {
  scope: 'DiscountAppComponents.SummaryCard.Combinations'
};
function Combinations({
  combinesWith
}) {
  const [i18n] = useI18n();
  const combinations = [...(combinesWith.productDiscounts ? [DiscountClass.Product] : []), ...(combinesWith.orderDiscounts ? [DiscountClass.Order] : []), ...(combinesWith.shippingDiscounts ? [DiscountClass.Shipping] : [])];
  return /*#__PURE__*/React.createElement(List.Item, null, getContent(combinations, i18n));
}
function getContent(combinations, i18n) {
  switch (combinations.length) {
    case 0:
      return i18n.translate('cannotCombine', I18N_SCOPE);
    case 1:
      return i18n.translate(`combinesWithOne.${combinations[0].toLowerCase()}`, I18N_SCOPE);
    case 2:
      return i18n.translate(`combinesWithTwo.${combinations[0].toLowerCase()}And${capitalizeFirstLetter(combinations[1].toLowerCase())}`, I18N_SCOPE);
    default:
      return '';
  }
}
function capitalizeFirstLetter(text) {
  return text.charAt(0).toUpperCase() + text.slice(1);
}

export { Combinations };
