import React from 'react';
import { List } from '@shopify/polaris';
import { useI18n } from '@shopify/react-i18n';
import { PurchaseType } from '../../../../constants.js';

const I18N_SCOPE = {
  scope: 'DiscountAppComponents.SummaryCard.AppliesToPurchaseType'
};
function AppliesToPurchaseType({
  purchaseType
}) {
  const [i18n] = useI18n();
  return /*#__PURE__*/React.createElement(List.Item, null, getPurchaseTypeSummary(purchaseType, i18n));
}
const getPurchaseTypeSummary = (purchaseType, i18n) => {
  switch (purchaseType) {
    case PurchaseType.OneTimePurchase:
      return i18n.translate('appliesToPurchaseTypeOneTime', I18N_SCOPE);
    case PurchaseType.Subscription:
      return i18n.translate('appliesToPurchaseTypeSubscription', I18N_SCOPE);
    case PurchaseType.Both:
      return i18n.translate('appliesToPurchaseTypeBoth', I18N_SCOPE);
  }
};

export { AppliesToPurchaseType };
