import React from 'react';
import styles from './SelectedItemsList.scss.js';
import { Item } from './components/Item/Item.js';

function SelectedItemsList({
  items,
  renderItem,
  onRemoveItem
}) {
  return /*#__PURE__*/React.createElement("ul", {
    className: styles.SelectedItemsList
  }, items.map(item => {
    return /*#__PURE__*/React.createElement(Item, Object.assign({
      key: item.id
    }, onRemoveItem && {
      onRemove: () => onRemoveItem(item.id)
    }), renderItem(item));
  }));
}

export { SelectedItemsList };
