import React from 'react';
import { LegacyCard, ChoiceList } from '@shopify/polaris';
import { useI18n } from '@shopify/react-i18n';
import { PurchaseType } from '../../constants.js';

function PurchaseTypeCard({
  purchaseType
}) {
  const [i18n] = useI18n();
  return /*#__PURE__*/React.createElement(LegacyCard, {
    sectioned: true,
    title: i18n.translate('DiscountAppComponents.PurchaseTypeList.title')
  }, /*#__PURE__*/React.createElement(ChoiceList, {
    title: i18n.translate('DiscountAppComponents.PurchaseTypeList.choiceList.title'),
    titleHidden: true,
    selected: [purchaseType.value],
    choices: [{
      label: i18n.translate('DiscountAppComponents.PurchaseTypeList.choiceList.oneTimePurchase'),
      value: PurchaseType.OneTimePurchase
    }, {
      label: i18n.translate('DiscountAppComponents.PurchaseTypeList.choiceList.subscription'),
      value: PurchaseType.Subscription
    }, {
      label: i18n.translate('DiscountAppComponents.PurchaseTypeList.choiceList.both'),
      value: PurchaseType.Both
    }],
    onChange: purchaseTypeList => {
      purchaseType.onChange(purchaseTypeList[0]);
    }
  }));
}

export { PurchaseTypeCard };
