import React, { StrictMode, Fragment } from 'react';
import { PolarisTestProvider } from '@shopify/polaris';
import { Provider } from '@shopify/app-bridge-react';
import { AppProvider } from '../AppProvider/AppProvider.js';

const DEFAULT_LOCALE = 'en-US';
const DEFAULT_IANA_TIMEZONE = 'America/Los_Angeles';
function DiscountAppComponentsTestProvider(props) {
  const Wrapper = props.strict ? StrictMode : Fragment;
  return /*#__PURE__*/React.createElement(Wrapper, null, /*#__PURE__*/React.createElement(Provider, {
    config: {
      apiKey: '12345',
      host: 'encodedHost'
    }
  }, /*#__PURE__*/React.createElement(AppProvider, {
    locale: props.locale || DEFAULT_LOCALE,
    ianaTimezone: props.ianaTimezone || DEFAULT_IANA_TIMEZONE
  }, /*#__PURE__*/React.createElement(PolarisTestProvider, null, /*#__PURE__*/React.createElement(React.Fragment, null, props.children)))));
}

export { DiscountAppComponentsTestProvider };
