import { useI18n } from '@shopify/react-i18n';

/**
 * @returns a function that takes a country code or `REST_OF_WORLD` and returns a localized country object
 */
function useLocalizeCountry() {
  const [i18n] = useI18n();
  return countryCode => ({
    id: countryCode,
    name: i18n.translate(countryCode, {
      scope: 'DiscountAppComponents.Countries'
    })
  });
}

export { useLocalizeCountry };
