import React from 'react';
import { LegacyCard, ChoiceList, Checkbox, InlineError } from '@shopify/polaris';
import { useI18n } from '@shopify/react-i18n';
import styles from './CountriesAndRatesCard.scss.js';
import { useLocalizeCountry } from './utilities.js';
import { CountrySelectionType } from '../../constants.js';
import { SelectedItemsList } from '../SelectedItemsList/SelectedItemsList.js';
import CurrencyField from '../CurrencyField/CurrencyField.js';

const EXCLUDE_SHIPPING_RATES_FIELD_ID = 'excludeShippingRatesOverTextField';
function CountriesAndRatesCard({
  countrySelectionType,
  selectedCountries,
  maximumShippingPrice,
  excludeShippingRates,
  countrySelector,
  currencyCode
}) {
  const [i18n] = useI18n();
  const localizeCountry = useLocalizeCountry();
  return /*#__PURE__*/React.createElement(LegacyCard, {
    title: i18n.translate('DiscountAppComponents.CountriesAndRatesCard.title')
  }, /*#__PURE__*/React.createElement(LegacyCard.Section, null, /*#__PURE__*/React.createElement(ChoiceList, {
    title: i18n.translate('DiscountAppComponents.CountriesAndRatesCard.choiceList.title'),
    titleHidden: true,
    choices: [{
      value: CountrySelectionType.AllCountries,
      label: i18n.translate('DiscountAppComponents.CountriesAndRatesCard.choiceList.all')
    }, {
      value: CountrySelectionType.SelectedCountries,
      label: i18n.translate('DiscountAppComponents.CountriesAndRatesCard.choiceList.selected')
    }],
    selected: [countrySelectionType.value],
    onChange: values => countrySelectionType.onChange(values[0])
  }), countrySelectionType.value === CountrySelectionType.SelectedCountries && /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement("div", {
    className: styles.countrySelectorActivator
  }, countrySelector), /*#__PURE__*/React.createElement(SelectedItemsList, {
    items: selectedCountries.value.map(localizeCountry),
    renderItem: item => /*#__PURE__*/React.createElement("div", null, item.name),
    onRemoveItem: itemId => selectedCountries.onChange(selectedCountries.value.filter(countryCode => countryCode !== itemId))
  }))), /*#__PURE__*/React.createElement(LegacyCard.Section, {
    title: i18n.translate('DiscountAppComponents.CountriesAndRatesCard.excludeShippingRatesSection.title')
  }, /*#__PURE__*/React.createElement(Checkbox, {
    label: i18n.translate('DiscountAppComponents.CountriesAndRatesCard.excludeShippingRatesSection.checkboxLabel'),
    checked: excludeShippingRates.value,
    onChange: value => excludeShippingRates.onChange(value)
  }), excludeShippingRates.value && /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement("div", {
    className: styles.ShippingRatesTextField
  }, /*#__PURE__*/React.createElement(CurrencyField, {
    id: EXCLUDE_SHIPPING_RATES_FIELD_ID,
    currencyCode: currencyCode,
    error: Boolean(maximumShippingPrice.error),
    labelHidden: true,
    label: i18n.translate('DiscountAppComponents.CountriesAndRatesCard.excludeShippingRatesSection.checkboxLabel'),
    onChange: maximumShippingPrice.onChange,
    value: String(maximumShippingPrice.value),
    positiveOnly: true
  })), (maximumShippingPrice === null || maximumShippingPrice === void 0 ? void 0 : maximumShippingPrice.error) && /*#__PURE__*/React.createElement(InlineError, {
    fieldID: EXCLUDE_SHIPPING_RATES_FIELD_ID,
    message: maximumShippingPrice.error
  }))));
}

export { CountriesAndRatesCard };
