import React, { useRef } from 'react';
import { LegacyStack, Text, Button, Link } from '@shopify/polaris';
import { useI18n } from '@shopify/react-i18n';
import { useAppBridge } from '@shopify/app-bridge-react';
import { Modal } from '@shopify/app-bridge/actions';
import { Action } from '@shopify/app-bridge/actions/Modal';

const DISCOUNT_COMBINATION_MODAL_APP_BRIDGE_URL = 'shopify://app-bridge/modal/discounts-combinations';
function HelpText({
  currentDiscountClass,
  targetDiscountClass,
  currentDiscountId,
  count,
  currentDiscountName
}) {
  const buttonWrapperRef = useRef(null);
  const [i18n] = useI18n();
  const app = useAppBridge();
  const myModal = Modal.create(app, {
    url: DISCOUNT_COMBINATION_MODAL_APP_BRIDGE_URL
  });
  const targetDiscountClassLabel = targetDiscountClass.toLocaleLowerCase();
  const scope = `DiscountAppComponents.CombinationCard.HelpText`;
  const handleModalOpen = () => {
    myModal.dispatch(Action.DATA, {
      discountOptions: {
        currentDiscountName,
        currentDiscountClass,
        currentDiscountId,
        targetDiscountClass
      }
    });
    myModal.dispatch(Modal.Action.OPEN);
    const closeUnsubscribe = myModal.subscribe(Modal.Action.CLOSE, () => {
      var _buttonWrapperRef$cur, _buttonWrapperRef$cur2;
      (_buttonWrapperRef$cur = buttonWrapperRef.current) === null || _buttonWrapperRef$cur === void 0 ? void 0 : (_buttonWrapperRef$cur2 = _buttonWrapperRef$cur.getElementsByTagName('button')[0]) === null || _buttonWrapperRef$cur2 === void 0 ? void 0 : _buttonWrapperRef$cur2.focus();
      closeUnsubscribe();
    });
  };
  return count > 0 ? /*#__PURE__*/React.createElement(LegacyStack, {
    spacing: "none",
    vertical: true
  }, /*#__PURE__*/React.createElement(Text, {
    as: "span",
    color: "subdued"
  }, i18n.translate('combinations.info', {
    scope
  }, {
    count,
    discountCountLink: /*#__PURE__*/React.createElement("span", {
      ref: buttonWrapperRef
    }, /*#__PURE__*/React.createElement(Button, {
      onClick: handleModalOpen,
      plain: true
    }, i18n.translate(`combinations.counts.${targetDiscountClassLabel}`, {
      scope
    }, {
      count
    })))
  })), /*#__PURE__*/React.createElement(Text, {
    as: "span",
    color: "subdued"
  }, i18n.translate('combinations.multipleEligibleDiscounts', {
    scope
  }))) : /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(Text, {
    as: "span",
    color: "subdued"
  }, i18n.translate('title', {
    scope: `${scope}.emptyState.${targetDiscountClass.toLowerCase()}`
  }), ' ', i18n.translate(`warning.with${currentDiscountClass.toLowerCase()}`, {
    scope: `${scope}.emptyState.${targetDiscountClass.toLowerCase()}`
  }), ' ', /*#__PURE__*/React.createElement(Link, {
    url: `https://help.shopify.com/${i18n.locale}/manual/discounts/combining-discounts`,
    external: true
  }, i18n.translate(`${scope}.emptyState.link`))));
}

export { HelpText };
