import React from 'react';
import { useI18n } from '@shopify/react-i18n';
import defaultTranslations from '../../../../_virtual/en.json.js';

function DiscountsI18nProvider({
  children
}) {
  const [, ShareTranslations] = useI18n({
    id: 'DiscountAppComponents',
    fallback: defaultTranslations,
    async translations(locale) {
      return import( /* webpackChunkName: "DiscountAppComponents-i18n", webpackMode: "lazy-once" */`../../../../../../locales/${locale}.json`).then(dictionary => {
        if (!dictionary) {
          return undefined;
        }
        return dictionary.default;
      });
    }
  });
  return /*#__PURE__*/React.createElement(ShareTranslations, null, children);
}

export { DiscountsI18nProvider };
