import React from 'react';
import { useAppBridge } from '@shopify/app-bridge-react';
import { Redirect } from '@shopify/app-bridge/actions';
import { Link } from '@shopify/polaris';
import { handleRedirect } from '../../utilities/navigation.js';

const AppBridgeLink = ({
  children,
  ...rest
}) => {
  const app = useAppBridge();
  const redirect = Redirect.create(app);
  return /*#__PURE__*/React.createElement(Link, Object.assign({
    onClick: () => handleRedirect({
      redirect,
      ...rest
    })
  }, rest), children);
};

export { AppBridgeLink };
