# Components

Our components are a collection of interface elements that can be reused and composed to build discounts-focused [AppBridge](https://shopify.dev/apps/tools/app-bridge) apps.

---

## Getting started

The component library was designed to help developers quickly create the best experience for Shopify merchants.

Each component includes information to help you implement them, such as:

- Explanations of the merchant problem it solves in the interface
- Examples so you can see the component in action
- Best practices and guidelines to use the component correctly

Learn more about developing apps and themes for Shopify on our [developer hub](https://developers.shopify.com/).

---

## Installing and implementing

- [Implementation instructions](https://github.com/Shopify/discount-app-components#using-the-repo) (requires HTML, React, a JS build tool)

---

## Learning resources

These resources have information on getting started with React and how to develop apps for Shopify.

### React

If you’re new to React, start with the official [React Getting Started documentation](https://facebook.github.io/react/docs/hello-world.html). As you read through the topics, follow along using the [React Hello World CodePen](http://codepen.io/gaearon/pen/ZpvBNJ?editors=0010) example.

Here are some additional resources:

- Online training at [reacttraining.com](https://reacttraining.com/), [buildwithreact.com](http://buildwithreact.com), and [reactforbeginners.com](https://reactforbeginners.com)
- Community resources in [Awesome React](https://github.com/enaqx/awesome-react)
- Answers in the various [React support communities](https://facebook.github.io/react/community/support.html)

### Shopify’s developer hub

Learn more about developing apps and themes for Shopify on our [developer hub](https://shopify.dev/).

---

## Feedback

Issues or feature requests can be created on the [discount-app-components GitHub page](https://github.com/Shopify/discount-app-components/issues).
