'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var polaris = require('@shopify/polaris');
var polarisIcons = require('@shopify/polaris-icons');
var reactI18n = require('@shopify/react-i18n');
var utilities = require('./utilities.js');
var dates = require('../../utilities/dates.js');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

const TIME_BLOCKLIST_REGEX = /[^\d\s:apmAPM]/g;
function TimePicker({
  label,
  labelHidden = false,
  time,
  disabled = false,
  disableTimesBefore
}) {
  const [i18n] = reactI18n.useI18n();
  const ianaTimezone = i18n.defaultTimezone;
  const locale = i18n.locale;
  const selectedDate = dates.getDateTimeInShopTimeZone(time.value, ianaTimezone);
  const localeFormattedTime = utilities.getLocalizedTimeForDate(selectedDate, locale);
  const [userInput, setUserInput] = React.useState(localeFormattedTime);
  const disableTimesBeforeInShopTZ = React.useMemo(() => {
    return disableTimesBefore ? dates.getDateTimeInShopTimeZone(disableTimesBefore, ianaTimezone) : undefined;
  }, [disableTimesBefore, ianaTimezone]);
  const options = React.useMemo(() => utilities.formatDateListAsOptionList(utilities.generateTimes(selectedDate, disableTimesBeforeInShopTZ), locale, ianaTimezone), [selectedDate, disableTimesBeforeInShopTZ, locale, ianaTimezone]);
  React.useEffect(() => {
    setUserInput(localeFormattedTime);
  }, [localeFormattedTime]);
  const handleTextFieldChange = inputValue => setUserInput(inputValue.replace(TIME_BLOCKLIST_REGEX, ''));
  const handleTextFieldBlur = () => {
    var _time$onBlur;
    if (userInput === localeFormattedTime) {
      return;
    }
    const requestedNewTime = utilities.getValidDateForTime(userInput, selectedDate, ianaTimezone);
    const userInputInShopTimeZone = requestedNewTime && dates.getDateInShopTimeZone(requestedNewTime, ianaTimezone);
    const hasDisabledTimesAndInputIsAfterDisabledTime = userInputInShopTimeZone && disableTimesBeforeInShopTZ && userInputInShopTimeZone >= disableTimesBeforeInShopTZ;

    // set the time if the user input is a valid time string and the browser time in the shop TZ is not before disableTimesBefore
    if (requestedNewTime && (!disableTimesBeforeInShopTZ || hasDisabledTimesAndInputIsAfterDisabledTime)) {
      time.onChange(requestedNewTime.toISOString());
    } else {
      setUserInput(localeFormattedTime);
    }
    (_time$onBlur = time.onBlur) === null || _time$onBlur === void 0 ? void 0 : _time$onBlur.call(time);
  };
  return /*#__PURE__*/React__default["default"].createElement(polaris.Autocomplete, {
    options: options,
    selected: [time.value],
    onSelect: selected => time.onChange(selected[0]),
    textField: /*#__PURE__*/React__default["default"].createElement(polaris.Autocomplete.TextField, {
      label: label,
      labelHidden: labelHidden,
      prefix: /*#__PURE__*/React__default["default"].createElement(polaris.Icon, {
        source: polarisIcons.ClockMinor,
        color: "subdued"
      }),
      placeholder: i18n.translate('DiscountAppComponents.TimePicker.timePlaceholder'),
      autoComplete: "off",
      error: time.error,
      onBlur: handleTextFieldBlur,
      onChange: handleTextFieldChange,
      value: userInput,
      disabled: disabled
    })
  });
}

exports.TimePicker = TimePicker;
