'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var polaris = require('@shopify/polaris');
var reactI18n = require('@shopify/react-i18n');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

const I18N_SCOPE = {
  scope: 'DiscountAppComponents.SummaryCard.UsageLimits'
};
function UsageLimits({
  totalUsageLimit,
  oncePerCustomer
}) {
  const [i18n] = reactI18n.useI18n();
  return /*#__PURE__*/React__default["default"].createElement(polaris.List.Item, null, getUsageSummary(totalUsageLimit, oncePerCustomer, i18n));
}
const getUsageSummary = (totalUsageLimit, oncePerCustomer, i18n) => {
  const hasValidUsageLimit = totalUsageLimit !== null && totalUsageLimit.length > 0;
  if (hasValidUsageLimit) {
    return i18n.translate(oncePerCustomer ? 'totalUsageLimitWithOneUsePerCustomer' : 'totalUsageLimit', I18N_SCOPE, {
      count: Number(totalUsageLimit)
    });
  } else if (oncePerCustomer) {
    return i18n.translate('oneUsePerCustomer', I18N_SCOPE);
  } else {
    return i18n.translate('noUsageLimits', I18N_SCOPE);
  }
};

exports.UsageLimits = UsageLimits;
