'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var polaris = require('@shopify/polaris');
var reactI18n = require('@shopify/react-i18n');
var constants = require('../../../../constants.js');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

const I18N_SCOPE = {
  scope: 'DiscountAppComponents.SummaryCard.SelectedCountries'
};
function SelectedCountries({
  countrySelectionType,
  selectedCountries
}) {
  const [i18n] = reactI18n.useI18n();
  if (countrySelectionType === constants.CountrySelectionType.SelectedCountries && selectedCountries.length === 0) {
    return null;
  }
  if (countrySelectionType === constants.CountrySelectionType.AllCountries) {
    return /*#__PURE__*/React__default["default"].createElement(polaris.List.Item, null, i18n.translate('forAllCountries', I18N_SCOPE));
  }
  return selectedCountries.length === 1 ? /*#__PURE__*/React__default["default"].createElement(polaris.List.Item, null, i18n.translate('forSpecificCountry', I18N_SCOPE, {
    countryName: i18n.translate(selectedCountries[0], {
      scope: 'DiscountAppComponents.Countries'
    })
  })) : /*#__PURE__*/React__default["default"].createElement(polaris.List.Item, null, i18n.translate('forNumberOfCountries', I18N_SCOPE, {
    numberOfCountries: selectedCountries.length
  }));
}

exports.SelectedCountries = SelectedCountries;
