'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var polaris = require('@shopify/polaris');
var reactI18n = require('@shopify/react-i18n');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

function MaximumShippingPrice({
  maximumShippingPrice,
  currencyCode
}) {
  const [i18n] = reactI18n.useI18n();
  const priceAsNumber = Number(maximumShippingPrice);
  const validatedPrice = isNaN(priceAsNumber) ? '' : i18n.formatCurrency(priceAsNumber, {
    currency: currencyCode
  });
  if (priceAsNumber <= 0 || validatedPrice.length < 1) {
    return null;
  }
  return /*#__PURE__*/React__default["default"].createElement(polaris.List.Item, null, i18n.translate('DiscountAppComponents.SummaryCard.RatesExclusion.forShippingRatesUnder', {
    value: validatedPrice
  }));
}

exports.MaximumShippingPrice = MaximumShippingPrice;
