'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var reactI18n = require('@shopify/react-i18n');
var polaris = require('@shopify/polaris');
var dates = require('@shopify/dates');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

const I18N_SCOPE = {
  scope: 'DiscountAppComponents.SummaryCard.ActiveDates'
};
function ActiveDates({
  startDate,
  endDate
}) {
  const [i18n] = reactI18n.useI18n();
  return /*#__PURE__*/React__default["default"].createElement(polaris.List.Item, null, getDateSummary(startDate, endDate, i18n));
}
const getDateSummary = (startDate, endDate, i18n) => {
  const ianaTimezone = i18n.defaultTimezone;
  const startDateAsDate = new Date(startDate);
  const startsAtIsToday = dates.isToday(startDateAsDate, ianaTimezone);
  if (!endDate || startDate === endDate) {
    const date = startsAtIsToday ? i18n.translate('today', I18N_SCOPE) : formatDateForSummary(startDateAsDate, i18n);
    return i18n.translate('activeFromDate', I18N_SCOPE, {
      date
    });
  }
  const endDateAsDate = new Date(endDate);
  const endsAtIsToday = dates.isToday(endDateAsDate, ianaTimezone);
  if (dates.isSameDay(startDateAsDate, endDateAsDate, ianaTimezone)) {
    const date = startsAtIsToday ? i18n.translate('today', I18N_SCOPE) : formatDateForSummary(startDateAsDate, i18n);
    return i18n.translate('activeSingleDate', I18N_SCOPE, {
      date
    });
  } else if (startsAtIsToday) {
    return i18n.translate('activeFromTodayUntilDate', I18N_SCOPE, {
      date: formatDateForSummary(endDateAsDate, i18n)
    });
  } else if (endsAtIsToday) {
    return i18n.translate('activeFromDateUntilToday', I18N_SCOPE, {
      date: formatDateForSummary(startDateAsDate, i18n)
    });
  } else {
    return i18n.translate('activeFromDateToDate', I18N_SCOPE, {
      startDate: formatDateForSummary(startDateAsDate, i18n),
      endDate: formatDateForSummary(endDateAsDate, i18n)
    });
  }
};
const DATE_FORMATS = {
  sameYear: {
    month: 'short',
    day: 'numeric'
  },
  differentYear: {
    month: 'short',
    day: 'numeric',
    year: 'numeric'
  }
};
function formatDateForSummary(date, i18n) {
  const currentYear = new Date().getFullYear();
  return date.getFullYear() === currentYear ? i18n.formatDate(date, DATE_FORMATS.sameYear) : i18n.formatDate(date, DATE_FORMATS.differentYear);
}

exports.ActiveDates = ActiveDates;
