'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var reactI18n = require('@shopify/react-i18n');
var polaris = require('@shopify/polaris');
var Header = require('./components/Header/Header.js');
var AppliesToPurchaseType = require('./components/AppliesToPurchaseType/AppliesToPurchaseType.js');
var RecurringPayment = require('./components/RecurringPayment/RecurringPayment.js');
var SelectedCountries = require('./components/SelectedCountries/SelectedCountries.js');
var MaximumShippingPrice = require('./components/MaximumShippingPrice/MaximumShippingPrice.js');
var MinimumRequirements = require('./components/MinimumRequirements/MinimumRequirements.js');
var CustomerEligibility = require('./components/CustomerEligibility/CustomerEligibility.js');
var UsageLimits = require('./components/UsageLimits/UsageLimits.js');
var Combinations = require('./components/Combinations/Combinations.js');
var ActiveDates = require('./components/ActiveDates/ActiveDates.js');
var Performance = require('./components/Performance/Performance.js');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

/* eslint-disable @shopify/typescript/prefer-pascal-case-enums */
var OptionalSection = /*#__PURE__*/function (OptionalSection) {
  OptionalSection["activeDates"] = "activeDates";
  OptionalSection["additionalDetails"] = "additionalDetails";
  OptionalSection["appliesToPurchaseType"] = "appliesToPurchaseType";
  OptionalSection["combinations"] = "combinations";
  OptionalSection["customerEligibility"] = "customerEligibility";
  OptionalSection["maximumShippingPrice"] = "maximumShippingPrice";
  OptionalSection["minimumRequirements"] = "minimumRequirements";
  OptionalSection["recurringPayment"] = "recurringPayment";
  OptionalSection["selectedCountries"] = "selectedCountries";
  OptionalSection["usageLimits"] = "usageLimits";
  return OptionalSection;
}(OptionalSection || {});
const I18N_SCOPE = {
  scope: 'DiscountAppComponents.SummaryCard'
};
function SummaryCard(props) {
  var _props$additionalDeta;
  const [i18n] = reactI18n.useI18n();
  const showDetailsSection = Object.values(OptionalSection).some(section => props[section]);
  return /*#__PURE__*/React__default["default"].createElement(polaris.LegacyCard, {
    subdued: true,
    title: i18n.translate('title', I18N_SCOPE)
  }, /*#__PURE__*/React__default["default"].createElement(polaris.LegacyCard.Section, null, /*#__PURE__*/React__default["default"].createElement(polaris.LegacyStack, {
    vertical: true,
    spacing: "loose"
  }, /*#__PURE__*/React__default["default"].createElement(Header.Header, props.header), showDetailsSection && /*#__PURE__*/React__default["default"].createElement(polaris.LegacyStack, {
    vertical: true,
    spacing: "tight"
  }, /*#__PURE__*/React__default["default"].createElement(polaris.Text, {
    variant: "headingXs",
    as: "h3"
  }, i18n.translate('details', I18N_SCOPE)), /*#__PURE__*/React__default["default"].createElement(polaris.List, {
    type: "bullet"
  }, (_props$additionalDeta = props.additionalDetails) === null || _props$additionalDeta === void 0 ? void 0 : _props$additionalDeta.map(detail => /*#__PURE__*/React__default["default"].createElement(polaris.List.Item, {
    key: detail.replace(/\s/g, '-')
  }, detail)), props.appliesToPurchaseType && /*#__PURE__*/React__default["default"].createElement(AppliesToPurchaseType.AppliesToPurchaseType, props.appliesToPurchaseType), props.recurringPayment && /*#__PURE__*/React__default["default"].createElement(RecurringPayment.RecurringPayment, props.recurringPayment), props.selectedCountries && /*#__PURE__*/React__default["default"].createElement(SelectedCountries.SelectedCountries, props.selectedCountries), props.maximumShippingPrice && /*#__PURE__*/React__default["default"].createElement(MaximumShippingPrice.MaximumShippingPrice, props.maximumShippingPrice), props.minimumRequirements && /*#__PURE__*/React__default["default"].createElement(MinimumRequirements.MinimumRequirements, props.minimumRequirements), props.customerEligibility && /*#__PURE__*/React__default["default"].createElement(CustomerEligibility.CustomerEligibility, props.customerEligibility), props.usageLimits && /*#__PURE__*/React__default["default"].createElement(UsageLimits.UsageLimits, props.usageLimits), props.combinations && /*#__PURE__*/React__default["default"].createElement(Combinations.Combinations, props.combinations), props.activeDates && /*#__PURE__*/React__default["default"].createElement(ActiveDates.ActiveDates, props.activeDates))))), /*#__PURE__*/React__default["default"].createElement(Performance.Performance, props.performance));
}

exports.SummaryCard = SummaryCard;
