'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var polaris = require('@shopify/polaris');
var reactI18n = require('@shopify/react-i18n');
var constants = require('../../constants.js');
var DiscountCodeGenerator = require('../DiscountCodeGenerator/DiscountCodeGenerator.js');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

const DISCOUNT_TITLE_MAX_LENGTH = 255;
function MethodCard({
  title,
  discountClass,
  discountMethod,
  discountMethodHidden,
  discountTitle,
  discountCode,
  defaultDiscountCodeLength = constants.DEFAULT_DISCOUNT_CODE_LENGTH
}) {
  const [i18n] = reactI18n.useI18n();
  const handleChangeMethod = methods => {
    discountMethod.onChange(methods[0]);
  };
  return /*#__PURE__*/React__default["default"].createElement(polaris.LegacyCard, null, /*#__PURE__*/React__default["default"].createElement(polaris.LegacyCard.Section, null, /*#__PURE__*/React__default["default"].createElement(polaris.LegacyStack, {
    distribution: "equalSpacing",
    alignment: "center"
  }, /*#__PURE__*/React__default["default"].createElement(polaris.Text, {
    variant: "headingMd",
    as: "h2"
  }, title), /*#__PURE__*/React__default["default"].createElement(polaris.Text, {
    as: "span",
    color: "subdued"
  }, getDiscountClassLabel(discountClass, i18n)))), /*#__PURE__*/React__default["default"].createElement(polaris.LegacyCard.Section, {
    title: !discountMethodHidden && i18n.translate('DiscountAppComponents.MethodCard.methodSubtitle')
  }, /*#__PURE__*/React__default["default"].createElement(polaris.LegacyStack, {
    vertical: true
  }, !discountMethodHidden && /*#__PURE__*/React__default["default"].createElement(polaris.ChoiceList, {
    title: i18n.translate('DiscountAppComponents.MethodCard.choiceList.title'),
    titleHidden: true,
    choices: [{
      value: constants.DiscountMethod.Code,
      label: i18n.translate('DiscountAppComponents.MethodCard.choiceList.code')
    }, {
      value: constants.DiscountMethod.Automatic,
      label: i18n.translate('DiscountAppComponents.MethodCard.choiceList.automatic')
    }],
    selected: [discountMethod.value],
    onChange: handleChangeMethod
  }), discountMethod.value === constants.DiscountMethod.Code ? /*#__PURE__*/React__default["default"].createElement(DiscountCodeGenerator.DiscountCodeGenerator, {
    defaultLength: defaultDiscountCodeLength,
    discountCode: discountCode
  }) : /*#__PURE__*/React__default["default"].createElement(polaris.TextField, Object.assign({
    autoComplete: "off",
    label: i18n.translate('DiscountAppComponents.MethodCard.discountField.label'),
    helpText: i18n.translate('DiscountAppComponents.MethodCard.discountField.helpText'),
    maxLength: DISCOUNT_TITLE_MAX_LENGTH
  }, discountTitle)))));
}
const getDiscountClassLabel = (discountClass, i18n) => {
  switch (discountClass) {
    case constants.DiscountClass.Order:
      return i18n.translate('DiscountAppComponents.MethodCard.discountClassLabel.order');
    case constants.DiscountClass.Product:
      return i18n.translate('DiscountAppComponents.MethodCard.discountClassLabel.product');
    case constants.DiscountClass.Shipping:
      return i18n.translate('DiscountAppComponents.MethodCard.discountClassLabel.shipping');
    default:
      return '';
  }
};

exports.MethodCard = MethodCard;
