'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var polaris = require('@shopify/polaris');
var reactI18n = require('@shopify/react-i18n');
var utilities = require('./utilities.js');
var constants = require('../../constants.js');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

function DiscountCodeGenerator({
  discountCode,
  defaultLength = constants.DEFAULT_DISCOUNT_CODE_LENGTH
}) {
  const [i18n] = reactI18n.useI18n();
  const handleGenerateDiscount = () => discountCode.onChange(utilities.generateRandomDiscountCode(defaultLength));
  return /*#__PURE__*/React__default["default"].createElement(polaris.TextField, Object.assign({
    autoComplete: "off",
    label: i18n.translate('DiscountAppComponents.DiscountCodeGenerator.field.label'),
    helpText: i18n.translate('DiscountAppComponents.DiscountCodeGenerator.field.helpText')
  }, discountCode, {
    connectedRight: /*#__PURE__*/React__default["default"].createElement(polaris.Button, {
      onClick: handleGenerateDiscount
    }, i18n.translate('DiscountAppComponents.DiscountCodeGenerator.buttonText'))
  }));
}

exports.DiscountCodeGenerator = DiscountCodeGenerator;
