'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var reactI18n = require('@shopify/react-i18n');

/**
 * @returns a function that takes a country code or `REST_OF_WORLD` and returns a localized country object
 */
function useLocalizeCountry() {
  const [i18n] = reactI18n.useI18n();
  return countryCode => ({
    id: countryCode,
    name: i18n.translate(countryCode, {
      scope: 'DiscountAppComponents.Countries'
    })
  });
}

exports.useLocalizeCountry = useLocalizeCountry;
