'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var polaris = require('@shopify/polaris');
var reactI18n = require('@shopify/react-i18n');
var constants = require('../../constants.js');
var HelpText = require('./components/HelpText/HelpText.js');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

const I18N_SCOPE = {
  scope: 'DiscountAppComponents.CombinationCard'
};
function CombinationCard({
  discountClass,
  discountDescriptor,
  combinableDiscountTypes,
  combinableDiscountCounts,
  discountId
}) {
  const [i18n] = reactI18n.useI18n();
  const handleDiscountCombinesWithChange = selectedChoices => {
    combinableDiscountTypes.onChange({
      orderDiscounts: selectedChoices.includes(constants.DiscountClass.Order),
      productDiscounts: selectedChoices.includes(constants.DiscountClass.Product),
      shippingDiscounts: selectedChoices.includes(constants.DiscountClass.Shipping)
    });
  };
  const trimmedDescriptor = discountDescriptor.trim();
  const selectedChoices = getSelectedChoices(combinableDiscountTypes.value);
  const shouldShowBanner = discountClass === constants.DiscountClass.Order && (selectedChoices.includes(constants.DiscountClass.Product) || selectedChoices.includes(constants.DiscountClass.Order)) || discountClass === constants.DiscountClass.Product && selectedChoices.includes(constants.DiscountClass.Order);
  return /*#__PURE__*/React__default["default"].createElement(polaris.LegacyCard, {
    title: i18n.translate('title', I18N_SCOPE),
    sectioned: true
  }, /*#__PURE__*/React__default["default"].createElement(polaris.LegacyStack, {
    vertical: true,
    spacing: "baseTight"
  }, shouldShowBanner && /*#__PURE__*/React__default["default"].createElement(polaris.Banner, {
    title: i18n.translate('warning.title', I18N_SCOPE),
    status: "warning"
  }, /*#__PURE__*/React__default["default"].createElement("p", null, i18n.translate('warning.description', I18N_SCOPE), ' ', /*#__PURE__*/React__default["default"].createElement(polaris.Link, {
    url: `https://help.shopify.com/${i18n.locale}/manual/discounts/combining-discounts`,
    external: true
  }, i18n.translate('warning.link', I18N_SCOPE)))), /*#__PURE__*/React__default["default"].createElement("p", null, trimmedDescriptor ? /*#__PURE__*/React__default["default"].createElement(React__default["default"].Fragment, null, /*#__PURE__*/React__default["default"].createElement(polaris.Text, {
    as: "span",
    fontWeight: "semibold"
  }, trimmedDescriptor), ' ', i18n.translate('discountNameFilled', I18N_SCOPE)) : i18n.translate('discountNameNotFilled', I18N_SCOPE, {
    discountClass: i18n.translate(`discountClass.${discountClass.toLowerCase()}`, I18N_SCOPE)
  })), /*#__PURE__*/React__default["default"].createElement(polaris.ChoiceList, {
    title: i18n.translate('combinesWith', I18N_SCOPE),
    titleHidden: true,
    allowMultiple: true,
    choices: buildChoices({
      discountClass,
      discountId,
      discountDescriptor,
      i18n,
      combinableDiscountCounts
    }),
    selected: getSelectedChoices(combinableDiscountTypes.value),
    onChange: handleDiscountCombinesWithChange
  })));
}
function buildChoices({
  discountClass: currentDiscountClass,
  combinableDiscountCounts,
  discountId: currentDiscountId,
  discountDescriptor,
  i18n
}) {
  const hasCounts = typeof combinableDiscountCounts !== 'undefined';
  const productOption = {
    label: i18n.translate('options.productLabel', I18N_SCOPE),
    value: constants.DiscountClass.Product,
    renderChildren: isSelected => isSelected && hasCounts ? /*#__PURE__*/React__default["default"].createElement(HelpText.HelpText, {
      currentDiscountClass: currentDiscountClass,
      targetDiscountClass: constants.DiscountClass.Product,
      count: getActualCombiningDiscountsCount(combinableDiscountCounts.productDiscountsCount, currentDiscountClass === constants.DiscountClass.Product, currentDiscountId),
      currentDiscountId: currentDiscountId,
      currentDiscountName: discountDescriptor
    }) : null
  };
  const orderOption = {
    label: i18n.translate('options.orderLabel', I18N_SCOPE),
    value: constants.DiscountClass.Order,
    renderChildren: isSelected => isSelected && hasCounts ? /*#__PURE__*/React__default["default"].createElement(HelpText.HelpText, {
      currentDiscountClass: currentDiscountClass,
      targetDiscountClass: constants.DiscountClass.Order,
      count: getActualCombiningDiscountsCount(combinableDiscountCounts.orderDiscountsCount, currentDiscountClass === constants.DiscountClass.Order, currentDiscountId),
      currentDiscountId: currentDiscountId,
      currentDiscountName: discountDescriptor
    }) : null
  };
  const shippingOption = {
    label: i18n.translate('options.shippingLabel', I18N_SCOPE),
    value: constants.DiscountClass.Shipping,
    renderChildren: isSelected => isSelected && hasCounts ? /*#__PURE__*/React__default["default"].createElement(HelpText.HelpText, {
      currentDiscountClass: currentDiscountClass,
      targetDiscountClass: constants.DiscountClass.Shipping,
      count: getActualCombiningDiscountsCount(combinableDiscountCounts.shippingDiscountsCount, currentDiscountClass === constants.DiscountClass.Shipping, currentDiscountId),
      currentDiscountId: currentDiscountId,
      currentDiscountName: discountDescriptor
    }) : null
  };
  switch (currentDiscountClass) {
    case constants.DiscountClass.Product:
      return [productOption, orderOption, shippingOption];
    case constants.DiscountClass.Order:
      return [productOption, orderOption, shippingOption];
    case constants.DiscountClass.Shipping:
      return [productOption, orderOption];
    default:
      return [{
        label: '',
        value: ''
      }];
  }
}

/**
 * The combines with count needs to exclude the current discount if:
 *  - the current discount is of the same type as the combination discount type
 *  - the current discount is saved
 */
function getActualCombiningDiscountsCount(numCombinableDiscountsForClass, discountClassesMatch, currentDiscountId) {
  if (discountClassesMatch && Boolean(currentDiscountId)) {
    return numCombinableDiscountsForClass - 1;
  }
  return numCombinableDiscountsForClass;
}
const getSelectedChoices = combinableDiscountTypes => [...(combinableDiscountTypes.productDiscounts ? [constants.DiscountClass.Product] : []), ...(combinableDiscountTypes.orderDiscounts ? [constants.DiscountClass.Order] : []), ...(combinableDiscountTypes.shippingDiscounts ? [constants.DiscountClass.Shipping] : [])];

exports.CombinationCard = CombinationCard;
