'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var appBridgeReact = require('@shopify/app-bridge-react');
var actions = require('@shopify/app-bridge/actions');
var polaris = require('@shopify/polaris');
var navigation = require('../../utilities/navigation.js');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

const AppBridgeLink = ({
  children,
  ...rest
}) => {
  const app = appBridgeReact.useAppBridge();
  const redirect = actions.Redirect.create(app);
  return /*#__PURE__*/React__default["default"].createElement(polaris.Link, Object.assign({
    onClick: () => navigation.handleRedirect({
      redirect,
      ...rest
    })
  }, rest), children);
};

exports.AppBridgeLink = AppBridgeLink;
