const intl = new Map();
function memoizedGetDateTimeFormat(locales, options) {
  const key = dateTimeFormatCacheKey(locales, options);

  if (intl.has(key)) {
    return intl.get(key);
  }

  const i = new Intl.DateTimeFormat(locales, options);
  intl.set(key, i);
  return i;
}
const browserFeatureDetectionDate = Intl.DateTimeFormat('en', {
  hour: 'numeric'
}); // hourCycle to Intl.DateTimeFormatOptions was added in TS 4.2, so we could
// remove this, but that would require consumers to update to at least TS 4.2
// and be including the libs for es2020

const resolvedOptions = typeof browserFeatureDetectionDate.resolvedOptions === 'undefined' ? undefined : browserFeatureDetectionDate.resolvedOptions();
function formatDate(date, locales, options = {}) {
  const hourCycleRequired = resolvedOptions != null && options.hour12 === false && resolvedOptions.hourCycle != null;

  if (hourCycleRequired) {
    options.hour12 = undefined;
    options.hourCycle = 'h23';
  } // Etc/GMT+12 is not supported in most browsers and there is no equivalent fallback


  if (options.timeZone != null && options.timeZone === 'Etc/GMT+12') {
    const adjustedDate = new Date(date.valueOf() - 12 * 60 * 60 * 1000);
    return memoizedGetDateTimeFormat(locales, { ...options,
      timeZone: 'UTC'
    }).format(adjustedDate);
  }

  return memoizedGetDateTimeFormat(locales, options).format(date);
}
function dateTimeFormatCacheKey(locales, options = {}) {
  const localeKey = Array.isArray(locales) ? locales.sort().join('-') : locales;
  return `${localeKey}-${JSON.stringify(options)}`;
}

export { dateTimeFormatCacheKey, formatDate, memoizedGetDateTimeFormat };
