'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var getTimeZoneOffset = require('./get-time-zone-offset.js');

function applyTimeZoneOffset(date, timeZone1, timeZone2) {
  const initialOffset = getTimeZoneOffset.getTimeZoneOffset(date, timeZone1, timeZone2);
  const adjustedDate = new Date(date.valueOf() - initialOffset * 60 * 1000);
  const targetOffset = getTimeZoneOffset.getTimeZoneOffset(adjustedDate, timeZone1, timeZone2);
  const offsetDiff = targetOffset - initialOffset;
  return new Date(adjustedDate.valueOf() - offsetDiff * 60 * 1000);
}

exports.applyTimeZoneOffset = applyTimeZoneOffset;
