import { AppVersionsDiffQuery } from '../../api/graphql/app_versions_diff.js';
import { AppVersionByTagQuery } from '../../api/graphql/app_version_by_tag.js';
import { partnersRequest } from '@shopify/cli-kit/node/api/partners';
import { renderError } from '@shopify/cli-kit/node/ui';
import { AbortSilentError } from '@shopify/cli-kit/node/error';
export async function versionDiffByVersion(apiKey, version, token) {
    const versionDetails = await versionDetailsByVersion(apiKey, version, token);
    const { app: { versionsDiff }, } = await partnersRequest(AppVersionsDiffQuery, token, {
        apiKey,
        versionId: versionDetails.id,
    });
    return { versionsDiff, versionDetails };
}
async function versionDetailsByVersion(apiKey, version, token) {
    try {
        const { app: { appVersion }, } = await partnersRequest(AppVersionByTagQuery, token, {
            apiKey,
            versionTag: version,
        });
        return appVersion;
    }
    catch (err) {
        renderError({
            headline: "Version couldn't be released.",
            body: ['Version', { userInput: version }, 'could not be found.'],
        });
        throw new AbortSilentError();
    }
}
//# sourceMappingURL=version-diff.js.map