/// <reference types="node" resolution-mode="require"/>
import { ExtensionInstance } from '../../models/extensions/extension-instance.js';
import { FunctionConfigType } from '../../models/extensions/specifications/function.js';
import { BuildResult, BuildOptions } from 'esbuild';
import { AbortSignal } from '@shopify/cli-kit/node/abort';
import { Writable } from 'stream';
interface JSFunctionBuildOptions {
    stdout: Writable;
    stderr: Writable;
    signal?: AbortSignal;
    useTasks?: boolean;
}
export declare function buildJSFunction(fun: ExtensionInstance<FunctionConfigType>, options: JSFunctionBuildOptions): Promise<void>;
export declare function buildJSFunctionWithTasks(fun: ExtensionInstance<FunctionConfigType>, options: JSFunctionBuildOptions, builder: JavyBuilder): Promise<void>;
export declare function buildGraphqlTypes(fun: {
    directory: string;
    isJavaScript: boolean;
}, options: JSFunctionBuildOptions): Promise<void>;
export declare function bundleExtension(fun: ExtensionInstance<FunctionConfigType>, _options: JSFunctionBuildOptions): Promise<BuildResult<{
    entryPoints: string[];
    bundle?: boolean | undefined;
    splitting?: boolean | undefined;
    preserveSymlinks?: boolean | undefined;
    outfile?: string | undefined;
    metafile?: boolean | undefined;
    outdir?: string | undefined;
    outbase?: string | undefined;
    external?: string[] | undefined;
    packages?: "external" | undefined;
    alias?: Record<string, string> | undefined;
    loader?: {
        [ext: string]: import("esbuild").Loader;
    } | undefined;
    resolveExtensions?: string[] | undefined;
    mainFields?: string[] | undefined;
    conditions?: string[] | undefined;
    write?: boolean | undefined;
    allowOverwrite?: boolean | undefined;
    tsconfig?: string | undefined;
    outExtension?: {
        [ext: string]: string;
    } | undefined;
    publicPath?: string | undefined;
    entryNames?: string | undefined;
    chunkNames?: string | undefined;
    assetNames?: string | undefined;
    inject?: string[] | undefined;
    banner?: {
        [type: string]: string;
    } | undefined;
    footer?: {
        [type: string]: string;
    } | undefined;
    stdin?: import("esbuild").StdinOptions | undefined;
    plugins?: import("esbuild").Plugin[] | undefined;
    absWorkingDir?: string | undefined;
    nodePaths?: string[] | undefined;
    sourcemap?: boolean | "external" | "inline" | "linked" | "both" | undefined;
    legalComments?: "external" | "none" | "inline" | "eof" | "linked" | undefined;
    sourceRoot?: string | undefined;
    sourcesContent?: boolean | undefined;
    format?: import("esbuild").Format | undefined;
    globalName?: string | undefined;
    target?: string | string[] | undefined;
    supported?: Record<string, boolean> | undefined;
    platform?: import("esbuild").Platform | undefined;
    mangleProps?: RegExp | undefined;
    reserveProps?: RegExp | undefined;
    mangleQuoted?: boolean | undefined;
    mangleCache?: Record<string, string | false> | undefined;
    drop?: import("esbuild").Drop[] | undefined;
    minify?: boolean | undefined;
    minifyWhitespace?: boolean | undefined;
    minifyIdentifiers?: boolean | undefined;
    minifySyntax?: boolean | undefined;
    lineLimit?: number | undefined;
    charset?: import("esbuild").Charset | undefined;
    treeShaking?: boolean | undefined;
    ignoreAnnotations?: boolean | undefined;
    jsx?: "automatic" | "transform" | "preserve" | undefined;
    jsxFactory?: string | undefined;
    jsxFragment?: string | undefined;
    jsxImportSource?: string | undefined;
    jsxDev?: boolean | undefined;
    jsxSideEffects?: boolean | undefined;
    define?: {
        [key: string]: string;
    } | undefined;
    pure?: string[] | undefined;
    keepNames?: boolean | undefined;
    color?: boolean | undefined;
    logLevel?: import("esbuild").LogLevel | undefined;
    logLimit?: number | undefined;
    logOverride?: Record<string, import("esbuild").LogLevel> | undefined;
    tsconfigRaw?: string | {
        compilerOptions?: {
            alwaysStrict?: boolean | undefined;
            baseUrl?: boolean | undefined;
            experimentalDecorators?: boolean | undefined;
            importsNotUsedAsValues?: "error" | "preserve" | "remove" | undefined;
            jsx?: "preserve" | "react" | "react-native" | "react-jsx" | "react-jsxdev" | undefined;
            jsxFactory?: string | undefined;
            jsxFragmentFactory?: string | undefined;
            jsxImportSource?: string | undefined;
            paths?: Record<string, string[]> | undefined;
            preserveValueImports?: boolean | undefined;
            strict?: boolean | undefined;
            target?: string | undefined;
            useDefineForClassFields?: boolean | undefined;
            verbatimModuleSyntax?: boolean | undefined;
        } | undefined;
    } | undefined;
}>>;
export declare function runJavy(fun: ExtensionInstance<FunctionConfigType>, options: JSFunctionBuildOptions, extra?: string[]): Promise<void>;
interface FunctionRunnerOptions {
    json: boolean;
}
export declare function runFunctionRunner(fun: ExtensionInstance<FunctionConfigType>, options: FunctionRunnerOptions): Promise<void>;
export interface JavyBuilder {
    bundle(fun: ExtensionInstance<FunctionConfigType>, options: JSFunctionBuildOptions): Promise<BuildResult<BuildOptions>>;
    compile(fun: ExtensionInstance<FunctionConfigType>, options: JSFunctionBuildOptions): Promise<void>;
}
export declare const DefaultJavyBuilder: JavyBuilder;
export declare class ExportJavyBuilder implements JavyBuilder {
    exports: string[];
    constructor(exports: string[]);
    bundle(fun: ExtensionInstance<FunctionConfigType>, _options: JSFunctionBuildOptions): Promise<BuildResult<BuildOptions>>;
    compile(fun: ExtensionInstance<FunctionConfigType>, options: JSFunctionBuildOptions): Promise<void>;
    get wit(): string;
    get entrypointContents(): string;
}
export declare function jsExports(fun: ExtensionInstance<FunctionConfigType>): string[];
export {};
