/// <reference types="node" resolution-mode="require"/>
import { ExtensionsPayloadStore } from './payload/store.js';
import { ExtensionDevOptions } from '../extension.js';
import { AppInterface } from '../../../models/app/app.js';
import { ExtensionInstance } from '../../../models/extensions/extension-instance.js';
import { AbortSignal } from '@shopify/cli-kit/node/abort';
import { Writable } from 'stream';
export interface WatchEvent {
    path: string;
    type: 'build' | 'localization';
}
export interface FileWatcherOptions {
    devOptions: ExtensionDevOptions;
    payloadStore: ExtensionsPayloadStore;
}
export interface FileWatcher {
    close: () => void;
}
export declare function setupBundlerAndFileWatcher(options: FileWatcherOptions): Promise<{
    close: () => void;
}>;
interface SetupDraftableExtensionBundlerOptions {
    extension: ExtensionInstance;
    app: AppInterface;
    url: string;
    token: string;
    apiKey: string;
    registrationId: string;
    stderr: Writable;
    stdout: Writable;
    signal: AbortSignal;
    unifiedDeployment: boolean;
}
export declare function setupDraftableExtensionBundler({ extension, app, url, token, apiKey, registrationId, stderr, stdout, signal, unifiedDeployment, }: SetupDraftableExtensionBundlerOptions): Promise<void>;
interface SetupConfigWatcherOptions {
    extension: ExtensionInstance;
    token: string;
    apiKey: string;
    registrationId: string;
    stdout: Writable;
    stderr: Writable;
    signal: AbortSignal;
    unifiedDeployment: boolean;
}
export declare function setupConfigWatcher({ extension, token, apiKey, registrationId, stdout, stderr, signal, unifiedDeployment, }: SetupConfigWatcherOptions): Promise<void>;
export interface SetupFunctionWatcherOptions {
    extension: ExtensionInstance;
    app: AppInterface;
    stdout: Writable;
    stderr: Writable;
    signal: AbortSignal;
    token: string;
    apiKey: string;
    registrationId: string;
    unifiedDeployment: boolean;
}
export declare function setupFunctionWatcher({ extension, app, stdout, stderr, signal, token, apiKey, registrationId, unifiedDeployment, }: SetupFunctionWatcherOptions): Promise<void>;
export {};
