import { AppInterface } from '../models/app/app.js';
import { ExtensionInstance } from '../models/extensions/extension-instance.js';
import { Config } from '@oclif/core';
import { AbortSignal } from '@shopify/cli-kit/node/abort';
import { Writable } from 'stream';
export interface DevOptions {
    directory: string;
    id?: number;
    configName?: string;
    apiKey?: string;
    storeFqdn?: string;
    reset: boolean;
    update: boolean;
    commandConfig: Config;
    skipDependenciesInstallation: boolean;
    subscriptionProductUrl?: string;
    checkoutCartUrl?: string;
    tunnelUrl?: string;
    noTunnel: boolean;
    theme?: string;
    themeExtensionPort?: number;
    notify?: string;
}
declare function dev(options: DevOptions): Promise<void>;
interface DevDraftableExtensionsOptions {
    app: AppInterface;
    apiKey: string;
    url: string;
    token: string;
    extensions: ExtensionInstance[];
    remoteExtensions: {
        [key: string]: string;
    };
    unifiedDeployment: boolean;
}
export declare function devDraftableExtensionTarget({ extensions, app, url, apiKey, token, remoteExtensions, unifiedDeployment, }: DevDraftableExtensionsOptions): {
    prefix: string;
    action: (stdout: Writable, stderr: Writable, signal: AbortSignal) => Promise<void>;
};
export default dev;
