import { DeploymentMode } from './mode.js';
import { Identifiers, IdentifiersExtensions } from '../../models/app/identifiers.js';
import { AppDeploySchema, AppModuleSettings } from '../../api/graphql/app_deploy.js';
import { ExtensionInstance } from '../../models/extensions/extension-instance.js';
import { FunctionConfigType } from '../../models/extensions/specifications/function.js';
import { AlertCustomSection, TokenItem } from '@shopify/cli-kit/node/ui';
interface DeployThemeExtensionOptions {
    /** The application API key */
    apiKey: string;
    /** Set of local identifiers */
    identifiers: Identifiers;
    /** The token to send authenticated requests to the partners' API  */
    token: string;
}
/**
 * Uploads theme extension(s)
 * @param options - The upload options
 */
export declare function uploadThemeExtensions(themeExtensions: ExtensionInstance[], options: DeployThemeExtensionOptions): Promise<void>;
interface UploadExtensionsBundleOptions {
    /** The application API key */
    apiKey: string;
    /** The path to the bundle file to be uploaded */
    bundlePath?: string;
    /** The token to send authenticated requests to the partners' API  */
    token: string;
    /** App Modules extra data */
    appModules: AppModuleSettings[];
    /** The extensions' numeric identifiers (expressed as a string). */
    extensionIds: IdentifiersExtensions;
    /** The mode of the deployment */
    deploymentMode: DeploymentMode;
    /** App version message */
    message?: string;
    /** App version identifier */
    version?: string;
    /** The git reference url of the app version */
    commitReference?: string;
}
export interface UploadExtensionValidationError {
    uuid: string;
    errors: {
        message: string;
        field: string[];
    }[];
}
export interface UploadExtensionsBundleOutput {
    validationErrors: UploadExtensionValidationError[];
    versionTag: string;
    message?: string;
    location: string;
    deployError?: string;
}
type ErrorSectionBody = TokenItem;
interface ErrorCustomSection extends AlertCustomSection {
    body: ErrorSectionBody;
}
/**
 * Uploads a bundle.
 * @param options - The upload options
 */
export declare function uploadExtensionsBundle(options: UploadExtensionsBundleOptions): Promise<UploadExtensionsBundleOutput>;
export declare function deploymentErrorsToCustomSections(errors: AppDeploySchema['appDeploy']['userErrors'], extensionIds: IdentifiersExtensions, flags?: {
    version?: string;
}): ErrorCustomSection[];
/**
 * It generates a URL to upload an app bundle.
 * @param apiKey - The application API key
 * @param appVersionUUID - The unique identifier of the app version.
 */
export declare function getExtensionUploadURL(apiKey: string, appVersionUUID: string): Promise<string>;
interface UploadFunctionExtensionsOptions {
    /** The token to send authenticated requests to the partners' API  */
    token: string;
    identifiers: Identifiers;
}
/**
 * This function takes a list of function extensions and uploads them.
 * As part of the upload it creates a function server-side if it does not exist
 * and includes its remote identifier in the returned identifiers instance.
 * If the function already has a local id, that one is used and the upload
 * does an override of the function existing server-side.
 *
 * @param extensions - The list of extensions to upload.
 * @param options - Options to adjust the upload.
 * @returns A promise that resolves with the identifiers.
 */
export declare function uploadFunctionExtensions(extensions: ExtensionInstance<FunctionConfigType>[], options: UploadFunctionExtensionsOptions): Promise<Identifiers>;
export declare function uploadWasmBlob(extensionIdentifier: string, wasmPath: string, apiKey: string, token: string): Promise<{
    url: string;
    moduleId: string;
}>;
export {};
